/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import org.tigris.atlas.service.EntityServiceResponse;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.core.util.ServiceResponseUtils;
import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class InPersonAuthenticator {

    private static final InPersonAuthenticator instance = 
        new InPersonAuthenticator();

    /**
     * Returns a InPersonAuthentication instance.
     * @return a InPersonAuthentication instance.
     */
    public static final InPersonAuthenticator getInstance() {
        return instance;
    }

    /**
     * Hide constructor for singleton pattern
     */
    private InPersonAuthenticator() {
        // TODO: Implement singleton initialization
    }
    
    public InPersonAuthenticationServiceResponse authenticate(
        InPersonAuthentication ipa)
    {
        Precondition.assertNotNull("ipa", ipa);
        InPersonAuthenticationServiceResponse response = 
            gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.
            createInPersonAuthenticationServiceDelegate().authenticate(ipa);
        if (hasMpiCommunicationProblem(response)) {
            changeStatus(response, InPersonAuthenticationStatusUtils.
                PENDING_FAILED);
        } else if (hasMpiDataMatchingProblem(response)) {
            changeStatus(response, InPersonAuthenticationStatusUtils.
                PENDING_DATA_MISMATCH);
        }
        return response;
    }

    private boolean hasMpiCommunicationProblem(EntityServiceResponse response) {
        return ServiceResponseUtils.hasErrorMessage(response, MessageKeys.
                    MPI_ACCESS_PROBLEM_AT_IPA)
            || ServiceResponseUtils.hasErrorMessage(response, MessageKeys.
                    ENSEMBLE_ACCESS_PROBLEM_AT_IPA);
    }
    
    private boolean hasMpiDataMatchingProblem(EntityServiceResponse response) {
        return ServiceResponseUtils.hasErrorMessage(response, MessageKeys.
                PATIENT_NOT_FOUND_AT_IPA)
            || ServiceResponseUtils.hasErrorMessage(response, MessageKeys.
                DUPLICATE_PATIENT_ENTRY_AT_IPA);
    }

    private void changeStatus(InPersonAuthenticationServiceResponse response,
        AuthenticationStatus status)
    {
        assert status != null;
        assert response.getInPersonAuthentication() != null;
        response.getInPersonAuthentication().setStatus(status);
        InPersonAuthenticationServiceResponse saveResponse = 
            ServiceDelegateFactory.createEntityMaintenanceServiceDelegate().
            save(response.getInPersonAuthentication());
        ServiceResponseUtils.copyMessages(response, saveResponse);
        response.setInPersonAuthentication(saveResponse.
            getInPersonAuthentication());
    }
}
